<?php
/**
 * Plugin Name: Form230
 * Description: Form230 este un plugin WordPress ce simplifică completarea și generarea Formularului 230. Automatizează exportul formularului în format PDF și tabelar, facilitând astfel depunerea rapidă și corectă a formularelor de către ONG-uri.
 * Version: 1.0
 * Author: maghost
 * Author URI: https://maghost.ro
 * Plugin Icon: assets/form230_logo.png
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin paths and URLs
define('FORMULARUL230_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('FORMULARUL230_PLUGIN_URL', plugin_dir_url(__FILE__));

// Check PHP version compatibility
if (version_compare(PHP_VERSION, '5.6', '<')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p><strong>Form230 Error:</strong> Your PHP version (' . PHP_VERSION . ') is outdated. Please upgrade to PHP 5.6 or higher to use this plugin.</p></div>';
    });
    return;
}

// Check WordPress version compatibility
global $wp_version;
if (version_compare($wp_version, '4.7', '<')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p><strong>Form230 Error:</strong> Your WordPress version (' . esc_html($wp_version) . ') is outdated. Please upgrade to WordPress 4.7 or higher to use this plugin.</p></div>';
    });
    return;
}

// Include necessary files
$required_files = [
    FORMULARUL230_PLUGIN_PATH . 'includes/form-handler.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/database.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/pdf-generator.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/admin-interface.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/csv-export.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/submission-preview.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/enqueue.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/api-key-settings.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/settings.php',
    FORMULARUL230_PLUGIN_PATH . 'includes/go-premium.php',
];

foreach ($required_files as $file) {
    if (!file_exists($file)) {
        add_action('admin_notices', function () use ($file) {
            echo '<div class="error"><p><strong>Form230 Error:</strong> Missing required file: ' . esc_html($file) . '</p></div>';
        });
        return;
    }
    require_once $file;
}

// Register activation hook
register_activation_hook(__FILE__, 'formularul230_activate_api_key');
