<?php
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Activation function to generate and register API key with additional details
function formularul230_activate_api_key() {
    if (!get_option('formularul230_api_key')) {
        // Generate a plaintext API key (32 characters)
        $plaintext_api_key = bin2hex(random_bytes(16)); 
        
        // Store the plaintext API key in wp_options
        update_option('formularul230_api_key', $plaintext_api_key);

        // Gather additional details
        $domain = get_site_url();
        $admin_email = get_option('admin_email');
        $user = wp_get_current_user();
        $user_display_name = $user->display_name;
        $ip_address = sanitize_text_field(wp_unslash($_SERVER['SERVER_ADDR'] ?? 'Unknown'));

        // Prepare data for remote registration
        $data = [
            'api_key' => $plaintext_api_key, // Send plaintext key to server
            'domain' => $domain,
            'admin_email' => $admin_email,
            'user_display_name' => $user_display_name,
            'ip_address' => $ip_address,
            'status' => 'valid' // Include status for wpf2_api_keys compatibility
        ];

        // Register the API key with the external server
        $response = wp_remote_post('https://form230.ro/api/register-key.php', [
            'body' => json_encode($data),
            'headers' => ['Content-Type' => 'application/json'],
            'timeout' => 15,
        ]);

        if (is_wp_error($response) || wp_remote_retrieve_response_code($response) !== 200) {
            // Log failure for debugging
            error_log('Failed to register API key: ' . $plaintext_api_key . ' - Response: ' . (is_wp_error($response) ? $response->get_error_message() : wp_remote_retrieve_body($response)));
            add_action('admin_notices', function() {
                echo '<div class="notice notice-error"><p>A eșuat înregistrarea cheii API pentru Formularul 230. Vă rugăm să contactați echipa de suport.</p></div>';
            });
        } else {
            error_log('API key registered successfully: ' . $plaintext_api_key);
        }
    }
}

// Register activation hook
if (defined('FORMULARUL230_PLUGIN_PATH')) {
    register_activation_hook(FORMULARUL230_PLUGIN_PATH . 'formularul230.php', 'formularul230_activate_api_key');
} else {
    // Fallback if constant is not defined
    register_activation_hook(__FILE__, 'formularul230_activate_api_key');
}

// Uninstall function to delete API key with domain info
function formularul230_uninstall_api_key() {
    $api_key = get_option('formularul230_api_key', '');
    if ($api_key) {
        // Include domain for verification
        $domain = get_site_url();
        $data = [
            'api_key' => $api_key,
            'domain' => $domain,
        ];

        // Notify server to delete the key
        $response = wp_remote_post('https://form230.ro/api/delete-key.php', [
            'body' => json_encode($data),
            'headers' => ['Content-Type' => 'application/json'],
            'timeout' => 15,
        ]);

        if (is_wp_error($response) || wp_remote_retrieve_response_code($response) !== 200) {
            error_log('Failed to delete API key during uninstall: ' . $api_key . ' - Response: ' . (is_wp_error($response) ? $response->get_error_message() : wp_remote_retrieve_body($response)));
        }

        // Delete the key from WordPress database
        delete_option('formularul230_api_key');
    }
}

// Register uninstall hook
if (defined('FORMULARUL230_PLUGIN_PATH')) {
    register_uninstall_hook(FORMULARUL230_PLUGIN_PATH . 'formularul230.php', 'formularul230_uninstall_api_key');
} else {
    // Fallback if constant is not defined
    register_uninstall_hook(__FILE__, 'formularul230_uninstall_api_key');
}