<?php
function formularul230_handle_bulk_actions($table_name) {
    global $wpdb;

    // Check if a bulk action is submitted along with selected submission IDs
    if (isset($_POST['bulk_action']) && isset($_POST['submission_ids'])) {
        // Verify nonce
        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['_wpnonce'])), 'formularul230_bulk_action')) {
            wp_die(esc_html__('Security check failed.', 'Formularul230'), '', array('response' => 403));
        }

        // Sanitize the action and IDs
        $action = sanitize_text_field(wp_unslash($_POST['bulk_action']));
        $submission_ids = array_map('intval', $_POST['submission_ids']);

        // Check if any submissions are selected
        if (empty($submission_ids)) {
            echo '<div class="error"><p>' . esc_html__('No submissions selected.', 'Formularul230') . '</p></div>';
            return;
        }

        if ($action === 'delete') {
            // Delete each selected submission
            foreach ($submission_ids as $id) {
                // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Direct query required for custom table
                $wpdb->delete($table_name, array('id' => $id), array('%d'));
            }
            echo '<div class="updated"><p>' . esc_html__('Selected submissions deleted successfully.', 'Formularul230') . '</p></div>';
        } else {
            echo '<div class="error"><p>' . esc_html__('Invalid action.', 'Formularul230') . '</p></div>';
        }
    }

    // Handle single deletion via GET
    if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
        // Verify nonce for single delete if needed (add nonce to the delete link)
        $id = intval($_GET['id']);
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Direct query required for custom table
        $wpdb->delete($table_name, array('id' => $id), array('%d'));
        echo '<div class="updated"><p>' . esc_html__('Submission deleted successfully.', 'Formularul230') . '</p></div>';
    }
}
?>