<?php
function formularul230_export_csv() {
    // Check if the export request is valid
    if (!isset($_GET['formularul230_export'])) {
        return; // Exit if this is not a CSV export request
    }

    // Verify nonce for security
    if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'formularul230_export_csv')) {
        wp_die(esc_html__('Invalid request.', 'Formularul230'), '', array('response' => 403));
    }

    // Check user permissions
    if (!current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'Formularul230'), '', array('response' => 403));
    }

    // Load WP_Filesystem
    if (!function_exists('WP_Filesystem')) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
    }
    global $wp_filesystem;
    if (!WP_Filesystem()) {
        wp_die(esc_html__('Could not initialize WP_Filesystem.', 'Formularul230'), '', array('response' => 500));
    }

    global $wpdb;
    $table_name = $wpdb->prefix . 'formularul230_submissions';

    if (isset($_GET['id'])) {
        // Export a single submission
        $id = intval($_GET['id']);
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $submission = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id), ARRAY_A);

        if ($submission) {
            // Set headers for CSV download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment; filename="submission-' . $id . '.csv"');

            // Start output buffering
            ob_start();

            // Build CSV content manually since WP_Filesystem doesn't natively support fputcsv
            $csv_content = implode(',', array_map('formularul230_escape_csv_field', array_keys($submission))) . "\n";
            $csv_content .= implode(',', array_map('formularul230_escape_csv_field', array_values($submission))) . "\n";

            // Write to php://output using WP_Filesystem
            $wp_filesystem->put_contents('php://output', $csv_content);

            // Get and output the CSV content
            // CSV is binary content and doesn't need escaping like HTML would
            echo ob_get_clean(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            exit;
        } else {
            wp_die(esc_html__('Submission not found.', 'Formularul230'), '', array('response' => 404));
        }
    } elseif (isset($_GET['export_all'])) {
        // Export all submissions
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $results = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name"), ARRAY_A);

        if (!empty($results)) {
            // Set headers for CSV download
            header('Content-Type: text/csv');
            header('Content-Disposition: attachment; filename="submissions.csv"');

            // Start output buffering
            ob_start();

            // Build CSV content manually
            $csv_content = implode(',', array_map('formularul230_escape_csv_field', array_keys($results[0]))) . "\n";
            foreach ($results as $row) {
                $csv_content .= implode(',', array_map('formularul230_escape_csv_field', array_values($row))) . "\n";
            }

            // Write to php://output using WP_Filesystem
            $wp_filesystem->put_contents('php://output', $csv_content);
            
            // Get and output the CSV content
            // CSV is binary content and doesn't need escaping like HTML would
            echo ob_get_clean(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            exit;
        } else {
            wp_die(esc_html__('No data to export.', 'Formularul230'), '', array('response' => 404));
        }
    }
}
add_action('admin_init', 'formularul230_export_csv');

/**
 * Escape a field for CSV output, handling quotes and commas.
 *
 * @param string $field The field value to escape.
 * @return string The escaped CSV field.
 */
function formularul230_escape_csv_field($field) {
    // Convert to string and escape quotes
    $field = strval($field);
    if (strpos($field, '"') !== false || strpos($field, ',') !== false || strpos($field, "\n") !== false) {
        $field = '"' . str_replace('"', '""', $field) . '"';
    }
    return $field;
}