<?php

// Create the database table on plugin activation
function formularul230_create_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'formularul230_submissions';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL,
        father_initial varchar(255) NOT NULL,
        prename varchar(255) NOT NULL,
        cnp varchar(13) NOT NULL,
        email varchar(255),
        phone varchar(12),
        city varchar(255) NOT NULL,
        county varchar(255) NOT NULL,
        street varchar(255) NOT NULL,
        number varchar(255),
        building varchar(255),
        stairway varchar(255),
        level varchar(255),
        apartment varchar(255),
        zip_code varchar(255),
        redirectionare varchar(3) NOT NULL,
        -- redirectionare_perioada varchar(255) NOT NULL,
        -- redirectionare_ani int, 
        signature text NOT NULL,
        data_consent tinyint(1) NOT NULL DEFAULT 0,
        created_at datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(FORMULARUL230_PLUGIN_PATH . 'formularul230.php', 'formularul230_create_table');