<?php

// Enqueue SweetAlert2 library (Corrected)
function formularul230_enqueue_sweetalert2()
{
    wp_enqueue_script('sweetalert2', 'https://cdn.jsdelivr.net/npm/sweetalert2@11', array(), '11.0.0', true);
}
add_action('admin_enqueue_scripts', 'formularul230_enqueue_sweetalert2');

// Enqueue signature JS functionality
function formularul230_enqueue_signature() {
    // Enqueue the form-specific JavaScript file and localize variables
    wp_enqueue_script(
        'formularul230-signature',
        FORMULARUL230_PLUGIN_URL . 'assets/js/signature.js',
        array(),
        '1.0.0',
        true
    );
    wp_localize_script(
        'formularul230-signature',
        'form230_ajax_obj',
        array(
            'ajax_url' => admin_url('admin-ajax.php'),
        )
    );
}
add_action('wp_enqueue_scripts', 'formularul230_enqueue_signature');


// Enqueue Admin Stylesheet
function formularul230_enqueue_admin_styles()
{
    wp_enqueue_style('formularul230-admin-style', FORMULARUL230_PLUGIN_URL . 'assets/css/admin-style.css', array(), '1.0.0');
}
add_action('admin_enqueue_scripts', 'formularul230_enqueue_admin_styles');

// Enqueue Frontend Stylesheet
function formularul230_enqueue_frontend_styles()
{
    wp_enqueue_style('formularul230-frontend-style', FORMULARUL230_PLUGIN_URL . 'assets/css/frontend-style.css', array(), '1.0.0');
}
add_action('wp_enqueue_scripts', 'formularul230_enqueue_frontend_styles');

// Enqueue Bootstrap CSS
function formularul230_enqueue_bootstrap()
{
    wp_enqueue_style(
        'bootstrap-css',
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css',
        array(),
        '5.3.0'
    );
}
add_action('wp_enqueue_scripts', 'formularul230_enqueue_bootstrap');