<?php

// Function to display the form via shortcode
function formularul230_display_form()
{
    ob_start(); // Start output buffering
    $nonce = wp_create_nonce('formularul230_submit_form_nonce'); // Generate a nonce
    ?>
    <form id="custom-form" method="post" class="formy_style">
        <input type="hidden" name="formularul230_nonce" value="<?php echo esc_attr($nonce); ?>">
        <div class="container">
            <div class="form_titleSection">
                <h4>Date personale</h4>
            </div>
            <div class="row">
                <div class="col-lg-5 col-md-12">
                    <div class="form_grup">
                        <label> Numele de familie</label>
                        <input type="text" name="your-name" autocomplete="name" required>
                    </div>
                </div>
                <div class="col-lg-2 col-md-12">
                    <div class="form_grup">
                        <label>Initiala tatălui</label>
                        <input type="text" name="your-father-initial" autocomplete="father-initial" required>
                    </div>
                </div>
                <div class="col-lg-5 col-md-12">
                    <div class="form_grup">
                        <label>Prenume</label>
                        <input type="text" name="your-prename" autocomplete="prename" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-12">
                    <div class="form_grup">
                        <label>CNP</label>
                        <input type="text" name="CNP" minlength="12" maxlength="13" placeholder="5250201018398" required>
                    </div>
                </div>
            </div>
            <div class="form_titleSection">
                <h4>Adresa de domiciliu</h4>
            </div>
            <div class="row">
                <div class="col-lg-10 col-md-12">
                    <div class="form_grup">
                        <label>Strada</label>
                        <input type="text" name="your-street" autocomplete="street" required>
                    </div>
                </div>
                <div class="col-lg-2 col-md-12">
                    <div class="form_grup">
                        <label> Numar</label>
                        <input type="text" name="your-number" autocomplete="number">
                    </div>
                </div>
                <div class="col-lg-2 col-md-12">
                    <div class="form_grup">
                        <label> Bloc</label>
                        <input type="text" name="your-building" autocomplete="building">
                    </div>
                </div>
                <div class="col-lg-2 col-md-12">
                    <div class="form_grup">
                        <label> Scara</label>
                        <input type="text" name="your-stairway" autocomplete="stairway">
                    </div>
                </div>
                <div class="col-lg-2 col-md-12">
                    <div class="form_grup">
                        <label> Etaj</label>
                        <input type="text" name="your-level" autocomplete="level">
                    </div>
                </div>
                <div class="col-lg-2 col-md-12">
                    <div class="form_grup">
                        <label> Apartament</label>
                        <input type="text" name="your-apartment" autocomplete="apartment">
                    </div>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="form_grup">
                        <label> Cod Poștal </label>
                        <input type="text" name="your-zip-code" autocomplete="zip-code">
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="form_grup">
                        <label> Localitate</label>
                        <input type="text" name="your-city" autocomplete="city" required>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="form_grup">
                        <label> Judet</label>
                        <input type="text" name="your-county" autocomplete="county" required>
                    </div>
                </div>
            </div>
            <div class="form_titleSection">
                <h4>Date de contact</h4>
            </div>
            <div class="row">
                <div class="col-lg-6 col-md-12">
                    <div class="form_grup">
                        <label> Numar de telefon </label>
                        <input type="tel" name="your-phone-number" minlength="9" maxlength="10" placeholder="0764103032"
                            required>
                    </div>
                </div>
                <div class="col-lg-6 col-md-12">
                    <div class="form_grup">
                        <label> Adresa ta de email </label>
                        <input type="email" name="your-email" autocomplete="email">
                    </div>
                </div>
            </div>
            <div class="row" style="margin-top: 30px;">
                <!-- <div class="col-lg-12">
                    <div class="form_grup">
                        <p>Sunteți de acord ca suma reprezentând până la 3,5% din impozitul anual pe veniturile din salarii
                            și asimilate salariilor, datorată de dumneavoastră, să fie virată către o entitate nonprofit,
                            unitate de cult sau pentru acordarea de burse private, conform legii?</p>
                        <div class="redirectionare_options">
                            <label>
                                <input type="radio" name="redirectionare_perioada" value="1" required> 1 an
                            </label>
                            <label>
                                <input type="radio" name="redirectionare_perioada" value="2"> 2 ani
                            </label>
                            <label>
                                <input type="radio" name="redirectionare_perioada" value="custom"> Altă perioadă (3-9 ani):
                                <input type="number" name="redirectionare_ani" min="3" max="9" style="width: 50px;"
                                    disabled>
                            </label>
                        </div>
                    </div>
                </div> -->
                <div class="col-lg-12">
                    <div class="form_group">
                        <div>
                            <label>
                                <input type="checkbox" name="data-consent" id="data-consent" required>
                                Sunt de acord ca datele de identificare (nume, prenume și cod numeric personal/număr de
                                identificare fiscală), precum și suma direcționată să fie comunicate entității beneficiare.
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="form_grup">
                        <div class="top_signature">
                            <p>Semnatura ta</p>
                        </div>
                        <div id="signature-pad"
                            style="border: 1px solid #000; width: 500px; height: 150px; overflow: hidden;">
                            <canvas id="signature-canvas"
                                style="width: 100%; height: 100%; display:block; touch-action: none;"></canvas>
                        </div>
                        <input type="hidden" id="signature-data" name="signature-data">
                        <button type="button" id="clear-signature" class="signature_btn">Șterge semnătura</button>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form_footer">
                    <input id="submit-form" type="submit" name="submit_form" value="Depune">
                </div>
            </div>
        </div>
    </form>
    <div id="form-messages"></div>
    <?php
    return ob_get_clean(); // Return the buffered content
}
add_shortcode('formularul230', 'formularul230_display_form');

// Function to handle form submission via AJAX
function formularul230_handle_ajax_form_submission()
{
    if (isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST') {
        $response = array();

        // Check nonce first before processing any POST data
        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Nonce is safely handled by wp_verify_nonce()
        if (!isset($_POST['formularul230_nonce']) || !wp_verify_nonce(wp_unslash($_POST['formularul230_nonce']), 'formularul230_submit_form_nonce')) {
            $response['success'] = false;
            $response['message'] = 'Eroare: Cererea nu este validă.';
            wp_send_json($response);
            wp_die();
        }

        try {
            // Check if PRO version (license key is empty for free version)
            $is_pro = false;
            $submission_count = (int) get_option('formularul230_submission_count', 0);
            $submission_limit = 1; // Define the limit for the free version

            // Enforce limit only for free version
            if (!$is_pro && $submission_count >= $submission_limit) {
                throw new Exception('Limita de depuneri pentru versiunea gratuită a fost atinsă (1). Vă rugăm să treceți la versiunea PRO.');
            }

            // Extract and sanitize all POST variables
            $post = [];
            foreach ($_POST as $key => $value) {
                $post[$key] = isset($_POST[$key]) ? sanitize_text_field(wp_unslash($_POST[$key])) : '';
            }

            // Validate the consent checkbox
            $data_consent = isset($post['data-consent']) ? sanitize_text_field($post['data-consent']) : '';
            if (empty($data_consent)) {
                throw new Exception('Trebuie să fiți de acord cu comunicarea datelor către entitatea beneficiară.');
            }

            // Validate and sanitize all fields
            $validation_rules = [
                'your-name' => [
                    'value' => $post['your-name'] ?? '',
                    'regex' => '/^[A-Za-zăâîșțĂÂÎȘȚ\- ]+$/u', // Allow "-" in addition to letters
                    'max' => 30,
                    'error' => 'Nume invalid (doar litere și "-", max 30 caractere)'
                ],
                'your-father-initial' => [
                    'value' => $post['your-father-initial'] ?? '',
                    'regex' => '/^[A-Za-zăâîșțĂÂÎȘȚ\.\-]+$/u', // Allow "-" in addition to letters and "."
                    'max' => 4,
                    'error' => 'Initiala tatălui invalidă (max 4 caractere)'
                ],
                'your-prename' => [
                    'value' => $post['your-prename'] ?? '',
                    'regex' => '/^[A-Za-zăâîșțĂÂÎȘȚ\- ]+$/u', // Allow "-" in addition to letters
                    'max' => 35,
                    'error' => 'Prenume invalid (max 35 caractere permise)'
                ],
                'CNP' => [
                    'value' => $post['CNP'] ?? '',
                    'regex' => '/^\d{13}$/', // CNP must still be exactly 13 digits
                    'error' => 'CNP invalid (exact 13 cifre)'
                ],
                'your-email' => [
                    'value' => $post['your-email'] ?? '',
                    'filter' => FILTER_VALIDATE_EMAIL,
                    'optional' => true, // Add this flag to indicate the field is optional
                    'error' => 'Adresă de email invalidă'
                ],
                'your-phone-number' => [
                    'value' => $post['your-phone-number'] ?? '',
                    'regex' => '/^\d{10}$/', // Phone number must still be exactly 10 digits
                    'error' => 'Număr de telefon invalid (exact 10 cifre)'
                ],
                'your-city' => [
                    'value' => $post['your-city'] ?? '',
                    'regex' => '/^[A-Za-zăâîșțĂÂÎȘȚ\- ]+$/u', // Allow "-"
                    'max' => 15,
                    'error' => 'Oraș invalid (max 15 litere)'
                ],
                'your-county' => [
                    'value' => $post['your-county'] ?? '',
                    'regex' => '/^[A-Za-zăâîșțĂÂÎȘȚ\- ]+$/u', // Allow "-"
                    'max' => 15,
                    'error' => 'Județ invalid (max 15 litere)'
                ],
                'your-street' => [
                    'value' => $post['your-street'] ?? '',
                    'regex' => '/^[A-Za-zăâîșțĂÂÎȘȚ0-9\- ]+$/u', // Allow letters, digits, "-", and spaces
                    'max' => 35,
                    'error' => 'Nume stradă invalid (max 35 caractere alfanumerice)'
                ],
                'your-number' => [
                    'value' => $post['your-number'] ?? '',
                    'regex' => '/^[A-Za-z0-9\-]{1,4}$/', // Allow "-"
                    'optional' => true, 
                    'error' => 'Număr invalid (max 4 caractere alfanumerice)'
                ],
                'your-building' => [
                    'value' => $post['your-building'] ?? '',
                    'regex' => '/^[a-zA-Z0-9\-]{0,4}$/', // Allow letters, digits, and "-"
                    'error' => 'Bloc invalid (max 4 caractere: litere, cifre sau "-")'
                ],
                'your-stairway' => [
                    'value' => $post['your-stairway'] ?? '',
                    'regex' => '/^[a-zA-Z0-9\-]{0,3}$/', // Allow letters, digits, and "-"
                    'error' => 'Scară invalidă (max 3 caractere: litere, cifre sau "-")'
                ],
                'your-level' => [
                    'value' => $post['your-level'] ?? '',
                    'regex' => '/^[a-zA-Z0-9\-]{0,3}$/', // Allow letters, digits, and "-"
                    'error' => 'Etaj invalid (max 3 caractere: litere, cifre sau "-")'
                ],
                'your-apartment' => [
                    'value' => $post['your-apartment'] ?? '',
                    'regex' => '/^[a-zA-Z0-9\-]{0,3}$/', // Allow letters, digits, and "-"
                    'error' => 'Apartament invalid (max 3 caractere: litere, cifre sau "-")'
                ],
                'your-zip-code' => [
                    'value' => $post['your-zip-code'] ?? '',
                    'regex' => '/^[\d\-]{1,6}$/', // Allow "-"
                    'optional' => true, 
                    'error' => 'Cod poștal invalid (max 6 cifre sau "-")'
                ],
                // 'redirectionare_perioada' => [
                //     'value' => $post['redirectionare_perioada'] ?? '',
                //     'options' => ['1', '2', 'custom'], // Allowed values
                //     'error' => 'Selectați o perioadă de redirecționare validă'
                // ],
                // 'redirectionare_ani' => [ 
                //     'value' => $post['redirectionare_ani'] ?? '',
                //     'regex' => '/^[3-9]?$/', // Only digits from 3 to 9 or empty
                //     'error' => 'Numărul de ani trebuie să fie între 3 și 9',
                //     'conditional' => 'redirectionare_perioada', // Only validate if redirection_perioada is 'custom'
                // ],
            ];

            $clean_data = [];
            foreach ($validation_rules as $field => $rules) {
                $value = trim(sanitize_text_field($rules['value']));

                // Check required fields
                if (
                    !isset($rules['optional']) && // If the field is NOT optional
                    in_array($field, [
                        'your-name',
                        'your-father-initial',
                        'your-prename',
                        'CNP',
                        'your-phone-number',
                        'your-city',
                        'your-county',
                        'your-street',
                        'your-number',
                    ]) && empty($value)
                ) {
                    throw new Exception('Toate câmpurile obligatorii trebuie completate.');
                }

                // Skip validation for optional fields if they are empty
                if (isset($rules['optional']) && empty($value)) {
                    continue; // Skip further validation for this field
                }

                // Special validation
                if (isset($rules['regex']) && !preg_match($rules['regex'], $value)) {
                    throw new Exception($rules['error']);
                }
                if (isset($rules['filter']) && !filter_var($value, $rules['filter'])) {
                    throw new Exception($rules['error']);
                }
                if (isset($rules['options']) && !in_array($value, $rules['options'])) {
                    throw new Exception($rules['error']);
                }
                if (isset($rules['max']) && mb_strlen($value) > $rules['max']) {
                    throw new Exception($rules['error']);
                }

                $clean_data[$field] = $value;
            }

            // Special CNP validation
            if (!ctype_digit($clean_data['CNP'])) {
                throw new Exception('CNP-ul trebuie să conțină doar cifre');
            }

            // Check if CNP already exists in the database
            global $wpdb;
            $table_name = $wpdb->prefix . 'formularul230_submissions';
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            $existing_submission = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE cnp = %s", $clean_data['CNP']), ARRAY_A);
            if ($existing_submission) {
                throw new Exception('Persoana cu acest CNP a completat deja Formularul 230!');
            }

            // Signature validation
            $signature = isset($post['signature-data']) ? $post['signature-data'] : '';
            if (empty($signature) || !preg_match('/^data:image\/(png|jpeg);base64/', $signature)) {
                throw new Exception('Vă rugăm să furnizați o semnătură validă');
            }

            // Prepare data for database
            $data_map = [
                'name' => $clean_data['your-name'],
                'father_initial' => $clean_data['your-father-initial'],
                'prename' => $clean_data['your-prename'],
                'cnp' => $clean_data['CNP'],
                'email' => $clean_data['your-email'],
                'phone' => $clean_data['your-phone-number'],
                'city' => $clean_data['your-city'],
                'county' => $clean_data['your-county'],
                'street' => $clean_data['your-street'],
                'number' => $clean_data['your-number'],
                'building' => $clean_data['your-building'],
                'stairway' => $clean_data['your-stairway'],
                'level' => $clean_data['your-level'],
                'apartment' => $clean_data['your-apartment'],
                'zip_code' => $clean_data['your-zip-code'],
                // 'redirectionare_perioada' => $clean_data['redirectionare_perioada'],
                // 'redirectionare_ani' => $clean_data['redirectionare_ani'],
                // 'redirectionare' => $clean_data['redirectionare'],
                'signature' => $signature,
                'data_consent' => !empty($data_consent) ? 1 : 0 // Save consent as 1 (true) or 0 (false)
            ];

            // Generate PDF
            $pdf_result = formularul230_generate_pdf($data_map, 'submit');
            if (is_array($pdf_result) && isset($pdf_result['error'])) {
                if (strpos($pdf_result['message'], 'Submission limit exceeded') !== false) {
                    throw new Exception('Limita de depuneri a fost atinsă (1). Vă rugăm să treceți la versiunea PRO.');
                } else {
                    throw new Exception('Generarea PDF-ului a esuat: ' . $pdf_result['message']);
                }
            } elseif (!$pdf_result) {
                throw new Exception('Generarea PDF-ului a esuat. A apărut o problemă la server.');
            }

            // Save to database
            global $wpdb;
            $table_name = $wpdb->prefix . 'formularul230_submissions';
            $result = $wpdb->insert($table_name, $data_map);
            if ($result === false) {
                throw new Exception('Eroare la salvarea în baza de date: ' . $wpdb->last_error);
            }

            // Increment submission count (only for free version)
            if (!$is_pro) {
                update_option('formularul230_submission_count', $submission_count + 1);
            }

            $remaining = $is_pro ? 'nelimitat' : ($submission_limit - ($submission_count + 1));
            $response['success'] = true;
            $response['message'] = 'Formular trimis cu succes! Vă mulțumim. (Depuneri rămase: ' . $remaining . ')';

        } catch (Exception $e) {
            $response['success'] = false;
            $response['message'] = 'Eroare: ' . $e->getMessage();
        }

        wp_send_json($response);
    }
    wp_die();
}

// Hook the AJAX handler
add_action('wp_ajax_formularul230_submit_form', 'formularul230_handle_ajax_form_submission');
add_action('wp_ajax_nopriv_formularul230_submit_form', 'formularul230_handle_ajax_form_submission');