<?php

// Register license settings page (still adds the menu item)
function form230_register_license_settings_page() {
    add_submenu_page(
        'formularul230-admin',                  // Parent slug
        __('Go PRO! - Form230', 'Formularul230'), // Page title (in browser tab/header)
        __('Go PRO!', 'Formularul230'),         // Menu title (in sidebar)
        'manage_options',                       // Capability
        'form230-license-settings',             // Menu slug
        '__return_null'                         // No callback needed, we'll handle via JS
    );
}
add_action('admin_menu', 'form230_register_license_settings_page');

// Add custom CSS and JS for premium styling and new tab behavior
function form230_style_go_pro_tab() {
    // Output CSS and JS only on admin pages
    ?>
    <style type="text/css">
        /* Target the "Go PRO!" submenu item by its slug */
        #toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"] {
            background: linear-gradient(135deg, #f9d423 0%, #e65f1d 100%);
            color: #fff;
            font-weight: 600;
            padding: 6px 12px 6px 10px;
            margin: 2px 0;
            display: flex;
            align-items: center;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease-in-out;
            position: relative;
            overflow: hidden;
            z-index: 1;
            cursor: pointer; /* Indicate it's clickable */
        }

        #toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"]::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: rgba(255, 255, 255, 0.2);
            transition: all 0.5s ease;
            opacity: 0;
            z-index: -1;
        }

        #toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"]:hover {
            background: linear-gradient(135deg, #ffd700 0%, #ff8c00 100%);
            transform: scale(1.05);
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.25);
        }

        #toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"]:hover::after {
            opacity: 1;
            left: 150%;
        }

        #toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"]::before {
            content: "\f155";
            font-family: "Dashicons";
            margin-right: 6px;
            font-size: 14px;
            line-height: 1;
            vertical-align: middle;
            color: #fff;
            transition: transform 0.3s ease-in-out;
            position: relative;
            z-index: 2;
        }

        #toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"]:hover::before {
            transform: scale(1.1);
        }

        #toplevel_page_formularul230-admin.wp-menu-open .wp-submenu li a[href="admin.php?page=form230-license-settings"] {
            padding-left: 10px;
        }
    </style>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            // Intercept click on the "Go PRO!" menu item and open in new tab
            $('#toplevel_page_formularul230-admin .wp-submenu li a[href="admin.php?page=form230-license-settings"]').on('click', function(e) {
                e.preventDefault(); // Prevent default redirect
                window.open('https://form230.ro', '_blank'); // Open in new tab
            });
        });
    </script>
    <?php
}
add_action('admin_head', 'form230_style_go_pro_tab');

// Enqueue jQuery (ensure it's available)
function form230_enqueue_scripts() {
    wp_enqueue_script('jquery');
}
add_action('admin_enqueue_scripts', 'form230_enqueue_scripts');