<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

$api_key = get_option('formularul230_api_key', '');
error_log('API Key being sent: ' . $api_key);

function formularul230_generate_pdf($data, $request_type = 'submit') {
    $api_key = get_option('formularul230_api_key', '');
    if (empty($api_key)) {
        error_log('No API key found in options');
        return false;
    }

    $api_data = array_merge($data, [
        'license_key' => '', // Keep empty since $is_pro is hardcoded false
        'api_key' => $api_key,
        'domain' => get_site_url(), // e.g., "https://radiovoceaevangheliei.ro"
        'request_type' => $request_type,
        'pdf_code_identificare' => get_option('formularul230_pdf_cod_identificare', ''),
        'pdf_denumire_entitate' => get_option('formularul230_pdf_denumire_entitate', ''),
        'pdf_cont_bancar' => get_option('formularul230_pdf_cont_bancar', ''),
        'pdf_procent_impozit' => get_option('formularul230_pdf_procent_impozit', ''),
        'pdf_suma_lei' => get_option('formularul230_pdf_suma_lei', ''),
        'empowered_user_nume_prenume' => get_option('formularul230_empowered_user_nume_prenume', ''),
        'empowered_user_cod_identificare_fiscal' => get_option('formularul230_empowered_user_cod_identificare_fiscal', ''),
        'empowered_user_strada' => get_option('formularul230_empowered_user_strada', ''),
        'empowered_user_numar' => get_option('formularul230_empowered_user_numar', ''),
        'empowered_user_bloc' => get_option('formularul230_empowered_user_bloc', ''),
        'empowered_user_scara' => get_option('formularul230_empowered_user_scara', ''),
        'empowered_user_etaj' => get_option('formularul230_empowered_user_etaj', ''),
        'empowered_user_ap' => get_option('formularul230_empowered_user_ap', ''),
        'empowered_user_judet_sector' => get_option('formularul230_empowered_user_judet_sector', ''),
        'empowered_user_localitate' => get_option('formularul230_empowered_user_localitate', ''),
        'empowered_user_cod_postal' => get_option('formularul230_empowered_user_cod_postal', ''),
        'empowered_user_telefon' => get_option('formularul230_empowered_user_telefon', ''),
        'empowered_user_fax' => get_option('formularul230_empowered_user_fax', ''),
        'empowered_user_email' => get_option('formularul230_empowered_user_email', ''),
        'pdf_font_family' => get_option('formularul230_pdf_font_family', 'helvetica'),
        'pdf_font_size' => get_option('formularul230_pdf_font_size', 12),
        'pdf_font_weight' => get_option('formularul230_pdf_font_weight', 'normal'),
        'pdf_text_color' => get_option('formularul230_pdf_text_color', '#000000'),
    ]);

    $api_url = 'https://form230.ro/api/generate-pdf.php';
    error_log('Sending request to: ' . $api_url);
    error_log('Request data: ' . json_encode($api_data));

    $response = wp_remote_post($api_url, [
        'body' => json_encode($api_data),
        'headers' => [
            'Content-Type' => 'application/json',
        ],
        'timeout' => 60,
    ]);

    if (is_wp_error($response)) {
        error_log('PDF API Error: ' . $response->get_error_message());
        return false;
    }

    $status_code = wp_remote_retrieve_response_code($response);
    $pdf_content = wp_remote_retrieve_body($response);
    error_log('API Response: Status ' . $status_code . ' - ' . $pdf_content);

    if ($status_code === 429) {
        error_log('PDF API Limit Exceeded: ' . $pdf_content);
        return ['error' => true, 'message' => $pdf_content];
    } elseif ($status_code !== 200) {
        error_log('PDF API Error: Status ' . $status_code . ' - ' . $pdf_content);
        return false;
    }

    return $pdf_content; // Return PDF binary string
}

if (!function_exists('formularul230_preview_pdf')) {
    function formularul230_preview_pdf($data) {
        return formularul230_generate_pdf($data, 'preview');
    }
}

if (!function_exists('formularul230_download_pdf')) {
    function formularul230_download_pdf($data) {
        return formularul230_generate_pdf($data, 'download');
    }
}