<?php

function formularul230_search_submissions($search_query) {
    global $wpdb;

    // Define the table name using the WordPress prefix
    $table_name = $wpdb->prefix . 'formularul230_submissions';

    if (!empty($search_query)) {
        // Escape the search query for use in LIKE
        $like = '%' . $wpdb->esc_like($search_query) . '%';
        
        // Prepare the SQL query with placeholders
        $sql = $wpdb->prepare(
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
            "SELECT * FROM {$table_name} WHERE name LIKE %s OR email LIKE %s",
            $like,
            $like
        );
    } else {
        // Directly use the table name without prepare since there are no variables
        $sql = "SELECT * FROM {$table_name}";
    }

    // Execute the query and return results
    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared -- The query is prepared above
    return $wpdb->get_results($sql, ARRAY_A);
}