<?php

// Add the combined settings page
function formularul230_add_settings_page() {
    add_submenu_page(
        'formularul230-admin',
        'Setări Form230',
        'Setări',
        'manage_options',
        'formularul230-settings',
        'formularul230_render_settings_page'
    );
}
add_action('admin_menu', 'formularul230_add_settings_page');

// Render the settings page with tabs
function formularul230_render_settings_page() {
    $current_tab = isset($_GET['tab']) ? sanitize_key($_GET['tab']) : 'general';
    ?>
    <div class="wrap">
        <h1>Setări Form230</h1>
        <nav class="nav-tab-wrapper">
            <a href="?page=formularul230-settings&tab=general" class="nav-tab <?php echo $current_tab === 'general' ? 'nav-tab-active' : ''; ?>">General</a>
            <a href="?page=formularul230-settings&tab=entitate" class="nav-tab <?php echo $current_tab === 'entitate' ? 'nav-tab-active' : ''; ?>">Entitate</a>
            <a href="?page=formularul230-settings&tab=imputernicit" class="nav-tab <?php echo $current_tab === 'imputernicit' ? 'nav-tab-active' : ''; ?>">Împuternicit</a>
        </nav>
        <div class="tab-content">
            <style>
                .two-column-layout {
                    display: grid;
                    grid-template-columns: 1fr 1fr;
                    max-width: 700px;
                }
                .form-field {
                    margin-bottom: 20px;
                }
                .form-field label {
                    display: block;
                    margin-bottom: 5px;
                    font-weight: bold;
                    width: 70%;
                }
                .form-field input[type="text"],
                .form-field input[type="email"],
                .form-field input[type="number"],
                .form-field select {
                    width: 100%;
                    max-width: 300px;
                }
            </style>

            <?php if ($current_tab === 'general') : ?>
                <form method="post" action="options.php">
                    <?php settings_fields('formularul230_general_settings_group'); ?>
                    <h2>Setări Generale</h2>
                    <?php formularul230_general_settings_section_callback(); ?>
                    <div class="two-column-layout">
                        <?php
                        formularul230_pdf_font_family_callback();
                        formularul230_pdf_font_size_callback();
                        formularul230_pdf_font_weight_callback();
                        formularul230_pdf_text_color_callback();
                        ?>
                    </div>
                    <?php submit_button('Salvează modificările'); ?>
                </form>
            <?php elseif ($current_tab === 'entitate') : ?>
                <form method="post" action="options.php">
                    <?php settings_fields('formularul230_entity_settings_group'); ?>
                    <h2>Setări Entitate Nonprofit</h2>
                    <?php formularul230_pdf_entity_settings_section_callback(); ?>
                    <div class="two-column-layout">
                        <?php
                        formularul230_pdf_cod_identificare_callback();
                        formularul230_pdf_denumire_entitate_callback();
                        formularul230_pdf_cont_bancar_callback();
                        formularul230_pdf_procent_impozit_callback();
                        formularul230_pdf_suma_lei_callback();
                        ?>
                    </div>
                    <?php submit_button('Salvează modificările'); ?>
                </form>
            <?php elseif ($current_tab === 'imputernicit') : ?>
                <form method="post" action="options.php">
                    <?php settings_fields('formularul230_empowered_user_settings_group'); ?>
                    <h2>Setări Împuternicit</h2>
                    <?php formularul230_empowered_user_settings_section_callback(); ?>
                    <div class="two-column-layout">
                        <?php
                        formularul230_empowered_user_nume_prenume_callback();
                        formularul230_empowered_user_cod_identificare_fiscal_callback();
                        formularul230_empowered_user_strada_callback();
                        formularul230_empowered_user_numar_callback();
                        formularul230_empowered_user_bloc_callback();
                        formularul230_empowered_user_scara_callback();
                        formularul230_empowered_user_etaj_callback();
                        formularul230_empowered_user_ap_callback();
                        formularul230_empowered_user_judet_sector_callback();
                        formularul230_empowered_user_localitate_callback();
                        formularul230_empowered_user_cod_postal_callback();
                        formularul230_empowered_user_telefon_callback();
                        formularul230_empowered_user_fax_callback();
                        formularul230_empowered_user_email_callback();
                        ?>
                    </div>
                    <?php submit_button('Salvează modificările'); ?>
                </form>
            <?php endif; ?>
        </div>
    </div>
    <?php
}

// Register all settings
function formularul230_register_settings() {
    // General Settings
    add_settings_section(
        'general_section',
        '',
        null,
        'formularul230-settings'
    );

    register_setting('formularul230_general_settings_group', 'formularul230_pdf_font_family', 'sanitize_text_field');
    register_setting('formularul230_general_settings_group', 'formularul230_pdf_font_size', 'intval');
    register_setting('formularul230_general_settings_group', 'formularul230_pdf_font_weight', 'sanitize_text_field');
    register_setting('formularul230_general_settings_group', 'formularul230_pdf_text_color', 'sanitize_hex_color');

    // Entity Settings
    add_settings_section(
        'entitate_section',
        '',
        null,
        'formularul230-settings'
    );

    register_setting('formularul230_entity_settings_group', 'formularul230_pdf_cod_identificare', 'formularul230_sanitize_required_field');
    register_setting('formularul230_entity_settings_group', 'formularul230_pdf_denumire_entitate', 'formularul230_sanitize_required_field');
    register_setting('formularul230_entity_settings_group', 'formularul230_pdf_cont_bancar', 'formularul230_sanitize_required_field');
    register_setting('formularul230_entity_settings_group', 'formularul230_pdf_procent_impozit', 'formularul230_sanitize_procent_impozit');
    register_setting('formularul230_entity_settings_group', 'formularul230_pdf_suma_lei', 'formularul230_sanitize_optional_field');

    // Empowered User Settings
    add_settings_section(
        'imputernicit_section',
        '',
        null,
        'formularul230-settings'
    );

    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_nume_prenume', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_cod_identificare_fiscal', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_strada', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_numar', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_bloc', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_scara', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_etaj', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_ap', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_judet_sector', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_localitate', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_cod_postal', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_telefon', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_fax', 'sanitize_text_field');
    register_setting('formularul230_empowered_user_settings_group', 'formularul230_empowered_user_email', 'sanitize_email');
}
add_action('admin_init', 'formularul230_register_settings');

// General Settings Callbacks
function formularul230_general_settings_section_callback() {
    echo '<p>Configurați setările generale pentru generarea PDF-urilor.</p>';
}

function formularul230_pdf_font_family_callback() {
    $value = get_option('formularul230_pdf_font_family', 'helvetica');
    $fonts = ['helvetica' => 'Helvetica', 'dejavusanscondensed' => 'DejaVu Sans Condensed', 'verdana' => 'Verdana'];
    echo '<div class="form-field"><label for="formularul230_pdf_font_family">Font Family</label>';
    echo '<select name="formularul230_pdf_font_family" id="formularul230_pdf_font_family">';
    foreach ($fonts as $key => $label) {
        echo '<option value="' . esc_attr($key) . '" ' . selected($value, $key, false) . '>' . esc_html($label) . '</option>';
    }
    echo '</select></div>';
}

function formularul230_pdf_font_size_callback() {
    $value = get_option('formularul230_pdf_font_size', 12);
    echo '<div class="form-field"><label for="formularul230_pdf_font_size">Font Size (pt)</label>';
    echo '<input type="number" name="formularul230_pdf_font_size" id="formularul230_pdf_font_size" value="' . esc_attr($value) . '" min="8" max="20" step="1"></div>';
}

function formularul230_pdf_font_weight_callback() {
    $value = get_option('formularul230_pdf_font_weight', 'normal');
    echo '<div class="form-field"><label for="formularul230_pdf_font_weight">Font Weight</label>';
    echo '<select name="formularul230_pdf_font_weight" id="formularul230_pdf_font_weight">';
    echo '<option value="normal" ' . selected($value, 'normal', false) . '>Normal</option>';
    echo '<option value="bold" ' . selected($value, 'bold', false) . '>Bold</option>';
    echo '</select></div>';
}

function formularul230_pdf_text_color_callback() {
    $value = get_option('formularul230_pdf_text_color', '#000000');
    echo '<div class="form-field"><label for="formularul230_pdf_text_color">Text Color</label>';
    echo '<input type="color" name="formularul230_pdf_text_color" id="formularul230_pdf_text_color" value="' . esc_attr($value) . '"></div>';
}

// Entity Settings Callbacks (unchanged)
function formularul230_pdf_entity_settings_section_callback() {
    echo '<p>Introduceți aici informațiile care vor fi incluse în secțiunea "II. Destinația sumei reprezentând până la 3,5% din impozitul anual pe veniturile din salarii şi asimilate salariilor" din formularul 230.</p>';
}

function formularul230_pdf_cod_identificare_callback() {
    $value = get_option('formularul230_pdf_cod_identificare');
    echo '<div class="form-field"><label for="formularul230_pdf_cod_identificare">Cod de identificare fiscală a entității nonprofit / unităţii de cult</label>';
    echo '<input type="text" name="formularul230_pdf_cod_identificare" id="formularul230_pdf_cod_identificare" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: 5213527" required></div>';
}

function formularul230_pdf_denumire_entitate_callback() {
    $value = get_option('formularul230_pdf_denumire_entitate');
    echo '<div class="form-field"><label for="formularul230_pdf_denumire_entitate">Denumire entitate nonprofit/unitate de cult</label>';
    echo '<input type="text" name="formularul230_pdf_denumire_entitate" id="formularul230_pdf_denumire_entitate" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: Asociația pentru Protecția Animalelor" required></div>';
}

function formularul230_pdf_cont_bancar_callback() {
    $value = get_option('formularul230_pdf_cont_bancar');
    echo '<div class="form-field"><label for="formularul230_pdf_cont_bancar">Cont bancar (IBAN)</label>';
    echo '<input type="text" name="formularul230_pdf_cont_bancar" id="formularul230_pdf_cont_bancar" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: RO49 AAAA 1B31 0075 9384 0000" required></div>';
}

function formularul230_pdf_procent_impozit_callback() {
    $value = get_option('formularul230_pdf_procent_impozit');
    $value = $value ? $value : 3.5;
    if ($value > 3.5) $value = 3.5;
    echo '<div class="form-field"><label for="formularul230_pdf_procent_impozit">Procentul din impozit (%)</label>';
    echo '<input type="number" step="0.5" name="formularul230_pdf_procent_impozit" id="formularul230_pdf_procent_impozit" value="' . esc_attr($value) . '" style="width: 100px;" placeholder="2.5" min="0" max="3.5" required> %</div>';
}

function formularul230_pdf_suma_lei_callback() {
    $value = get_option('formularul230_pdf_suma_lei');
    echo '<div class="form-field"><label for="formularul230_pdf_suma_lei">Suma (lei)</label>';
    echo '<input type="number" step="10" name="formularul230_pdf_suma_lei" id="formularul230_pdf_suma_lei" value="' . esc_attr($value) . '" style="width: 100px;" placeholder="100.00" min="0"> lei</div>';
}

// Empowered User Settings Callbacks (unchanged)
function formularul230_empowered_user_settings_section_callback() {
    echo '<p>Introduceți datele utilizatorului împuternicit care vor fi incluse în formularul PDF.</p>';
}

function formularul230_empowered_user_nume_prenume_callback() {
    $value = get_option('formularul230_empowered_user_nume_prenume');
    echo '<div class="form-field"><label for="formularul230_empowered_user_nume_prenume">Nume și prenume</label>';
    echo '<input type="text" name="formularul230_empowered_user_nume_prenume" id="formularul230_empowered_user_nume_prenume" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: Ion Popescu"></div>';
}

function formularul230_empowered_user_cod_identificare_fiscal_callback() {
    $value = get_option('formularul230_empowered_user_cod_identificare_fiscal');
    echo '<div class="form-field"><label for="formularul230_empowered_user_cod_identificare_fiscal">Cod de identificare fiscal</label>';
    echo '<input type="text" name="formularul230_empowered_user_cod_identificare_fiscal" id="formularul230_empowered_user_cod_identificare_fiscal" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: RO123456789"></div>';
}

function formularul230_empowered_user_strada_callback() {
    $value = get_option('formularul230_empowered_user_strada');
    echo '<div class="form-field"><label for="formularul230_empowered_user_strada">Strada</label>';
    echo '<input type="text" name="formularul230_empowered_user_strada" id="formularul230_empowered_user_strada" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: Strada Libertății"></div>';
}

function formularul230_empowered_user_numar_callback() {
    $value = get_option('formularul230_empowered_user_numar');
    echo '<div class="form-field"><label for="formularul230_empowered_user_numar">Număr</label>';
    echo '<input type="text" name="formularul230_empowered_user_numar" id="formularul230_empowered_user_numar" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: 123"></div>';
}

function formularul230_empowered_user_bloc_callback() {
    $value = get_option('formularul230_empowered_user_bloc');
    echo '<div class="form-field"><label for="formularul230_empowered_user_bloc">Bloc</label>';
    echo '<input type="text" name="formularul230_empowered_user_bloc" id="formularul230_empowered_user_bloc" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: A"></div>';
}

function formularul230_empowered_user_scara_callback() {
    $value = get_option('formularul230_empowered_user_scara');
    echo '<div class="form-field"><label for="formularul230_empowered_user_scara">Scară</label>';
    echo '<input type="text" name="formularul230_empowered_user_scara" id="formularul230_empowered_user_scara" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: B"></div>';
}

function formularul230_empowered_user_etaj_callback() {
    $value = get_option('formularul230_empowered_user_etaj');
    echo '<div class="form-field"><label for="formularul230_empowered_user_etaj">Etaj</label>';
    echo '<input type="text" name="formularul230_empowered_user_etaj" id="formularul230_empowered_user_etaj" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: 3"></div>';
}

function formularul230_empowered_user_ap_callback() {
    $value = get_option('formularul230_empowered_user_ap');
    echo '<div class="form-field"><label for="formularul230_empowered_user_ap">Apartament</label>';
    echo '<input type="text" name="formularul230_empowered_user_ap" id="formularul230_empowered_user_ap" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: 15"></div>';
}

function formularul230_empowered_user_judet_sector_callback() {
    $value = get_option('formularul230_empowered_user_judet_sector');
    echo '<div class="form-field"><label for="formularul230_empowered_user_judet_sector">Județ/Sector</label>';
    echo '<input type="text" name="formularul230_empowered_user_judet_sector" id="formularul230_empowered_user_judet_sector" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: Sectorul 1"></div>';
}

function formularul230_empowered_user_localitate_callback() {
    $value = get_option('formularul230_empowered_user_localitate');
    echo '<div class="form-field"><label for="formularul230_empowered_user_localitate">Localitate</label>';
    echo '<input type="text" name="formularul230_empowered_user_localitate" id="formularul230_empowered_user_localitate" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: București"></div>';
}

function formularul230_empowered_user_cod_postal_callback() {
    $value = get_option('formularul230_empowered_user_cod_postal');
    echo '<div class="form-field"><label for="formularul230_empowered_user_cod_postal">Cod poștal</label>';
    echo '<input type="text" name="formularul230_empowered_user_cod_postal" id="formularul230_empowered_user_cod_postal" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: 010101"></div>';
}

function formularul230_empowered_user_telefon_callback() {
    $value = get_option('formularul230_empowered_user_telefon');
    echo '<div class="form-field"><label for="formularul230_empowered_user_telefon">Telefon</label>';
    echo '<input type="text" name="formularul230_empowered_user_telefon" id="formularul230_empowered_user_telefon" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: +40722123456"></div>';
}

function formularul230_empowered_user_fax_callback() {
    $value = get_option('formularul230_empowered_user_fax');
    echo '<div class="form-field"><label for="formularul230_empowered_user_fax">Fax</label>';
    echo '<input type="text" name="formularul230_empowered_user_fax" id="formularul230_empowered_user_fax" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: +40211234567"></div>';
}

function formularul230_empowered_user_email_callback() {
    $value = get_option('formularul230_empowered_user_email');
    echo '<div class="form-field"><label for="formularul230_empowered_user_email">Email</label>';
    echo '<input type="email" name="formularul230_empowered_user_email" id="formularul230_empowered_user_email" value="' . esc_attr($value) . '" class="regular-text" placeholder="Exemplu: ion.popescu@example.com"></div>';
}

// Sanitization Functions
function formularul230_sanitize_required_field($value) {
    if (empty(trim($value))) {
        add_settings_error(
            'formularul230_entity_settings_group',
            'required_field_error',
            'Toate câmpurile, cu excepția Suma (lei), sunt obligatorii.',
            'error'
        );
        return '';
    }
    return sanitize_text_field($value);
}

function formularul230_sanitize_procent_impozit($value) {
    $value = floatval($value);
    if ($value > 3.5) $value = 3.5;
    return $value;
}

function formularul230_sanitize_optional_field($value) {
    return sanitize_text_field($value);
}