<?php
function formularul230_submission_preview()
{
    if (!isset($_GET['id'], $_GET['_wpnonce'])) {
        wp_die('Missing ID or nonce. Please use a valid link.');
    }

    $nonce = wp_unslash($_GET['_wpnonce']);
    $nonce = sanitize_text_field($nonce);

    if (!wp_verify_nonce($nonce, 'formularul230_preview_submission')) { 
        wp_die('Invalid or expired security token. Please refresh the page or try again.');
    }

    global $wpdb;
    $table_name = $wpdb->prefix . 'formularul230_submissions';

    if (isset($_GET['id'])) {
        $id = intval($_GET['id']);
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $submission = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id), ARRAY_A);

        if ($submission) {
            ?>
            <!-- Back Button -->
            <div class="back-button">
                <a href="?page=formularul230-admin">Înapoi la depuneri</a>
            </div>

            <div class="preview-wrapper">
                <!-- Submission Preview Container -->
                <div class="submission-container">
                    <h1>Depunerea
                        <?php echo esc_html($submission['id']) . ' - ' . esc_html($submission['prename']) . ' ' . esc_html($submission['name']); ?>
                    </h1>
                    <div class="grid-layout">
                        <div class="personal-info card-box">
                            <h2>Informații personale</h2>
                            <ul>
                                <li><strong>CNP:</strong> <?php echo esc_html($submission['cnp']); ?></li>
                                <li><strong>Nume:</strong> <?php echo esc_html($submission['name']); ?></li>
                                <li><strong>Inițiala tatălui:</strong> <?php echo esc_html($submission['father_initial']); ?></li>
                                <li><strong>Prenume:</strong> <?php echo esc_html($submission['prename']); ?></li>
                            </ul>
                        </div>
                        <div class="contact-data card-box">
                            <h2>Date de contact</h2>
                            <ul>
                                <li><strong>Email:</strong> <?php echo esc_html($submission['email']); ?></li>
                                <li><strong>Număr de telefon:</strong> <?php echo esc_html($submission['phone']); ?></li>
                            </ul>
                        </div>
                        <div class="address-section card-box" style="grid-column: span 2;">
                            <h2>Adresă</h2>
                            <div class="address-grid">
                                <ul>
                                    <li><strong>Oraș:</strong> <?php echo esc_html($submission['city']); ?></li>
                                    <li><strong>Județ:</strong> <?php echo esc_html($submission['county']); ?></li>
                                    <li><strong>Stradă:</strong> <?php echo esc_html($submission['street']); ?></li>
                                    <li><strong>Cod poștal:</strong> <?php echo esc_html($submission['zip_code']); ?></li>
                                </ul>
                                <ul>
                                    <li><strong>Număr:</strong> <?php echo esc_html($submission['number']); ?></li>
                                    <li><strong>Bloc:</strong> <?php echo esc_html($submission['building']); ?></li>
                                    <li><strong>Scară:</strong> <?php echo esc_html($submission['stairway']); ?></li>
                                    <li><strong>Etaj:</strong> <?php echo esc_html($submission['level']); ?></li>
                                    <li><strong>Apartament:</strong> <?php echo esc_html($submission['apartment']); ?></li>
                                </ul>
                            </div>
                        </div>
                        <div class="redirection card-box"
                            style="background-color: <?php echo $submission['redirectionare'] === 'DA' ? '#d4edda' : '#f8d7da'; ?>; border: 1px solid <?php echo $submission['redirectionare'] === 'DA' ? '#c3e6cb' : '#f5c6cb'; ?>;">
                            <strong>Redirecționare:</strong>
                            <?php
                            if ($submission['redirectionare'] === 'DA') {
                                echo 'Utilizatorul este de acord să distribuie suma pentru o perioadă de 2 ani.';
                            } else {
                                echo 'Utilizatorul nu este de acord să distribuie suma pentru o perioadă de 2 ani.';
                            }
                            ?>
                        </div>
                        <div class="consent card-box"
                            style="background-color: <?php echo $submission['data_consent'] ? '#d4edda' : '#f8d7da'; ?>; border: 1px solid <?php echo $submission['data_consent'] ? '#c3e6cb' : '#f5c6cb'; ?>;">
                            <strong>Consimțământ:</strong>
                            <?php
                            if ($submission['data_consent']) {
                                echo 'Utilizatorul a fost de acord să împărtășească datele sale personale cu entitatea beneficiară.';
                            } else {
                                echo 'Utilizatorul nu a fost de acord să împărtășească datele sale personale';
                            }
                            ?>
                        </div>
                        <div class="signature-section card-box" style="grid-column: span 2;">
                            <h2>Semnătură</h2>
                            <?php
                            if (!empty($submission['signature'])) {
                                $signature_base64 = sanitize_text_field($submission['signature']);
                                if (preg_match('/^data:image\/(png|jpeg|jpg|gif);base64,[A-Za-z0-9\/+]+={0,2}$/', $signature_base64)) {
                                    // phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage -- Base64 image data
                                    echo '<img src="' . esc_attr($signature_base64) . '" alt="Signature" class="signature-image">';
                                } else {
                                    echo '<p>Semnătura este invalidă (format base64 incorect).</p>';
                                }
                            } else {
                                echo '<p>Nu există semnătură disponibilă.</p>';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="date-section">
                        <ul>
                            <li><strong>Creat la:</strong>
                                <?php
                                $created_at = new DateTime($submission['created_at']);
                                echo esc_html($created_at->format('d F Y | H:i A'));
                                ?>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- PDF Preview Container -->
                <div class="pdf-preview-container">
                    <div class="pdf-preview-header">
                        <h2>Previzualizare PDF</h2>
                        <?php
                        $download_url = add_query_arg(
                            array(
                                'action' => 'formularul230_download_pdf',
                                'id' => (int) $id,
                                '_wpnonce' => wp_create_nonce('formularul230_download_nonce')
                            ),
                            admin_url('admin-ajax.php')
                        );
                        ?>
                        <a href="<?php echo esc_url($download_url); ?>" class="button button-primary" download>Descarcă PDF</a>
                    </div>
                    <?php
                    $preview_url = add_query_arg(
                        array(
                            'action' => 'formularul230_preview_pdf',
                            'id' => (int) $id,
                            '_wpnonce' => wp_create_nonce('formularul230_preview_nonce')
                        ),
                        admin_url('admin-ajax.php')
                    );
                    ?>
                    <iframe src="<?php echo esc_url($preview_url); ?>" title="PDF Preview"></iframe>
                </div>
            </div>
            <?php
        } else {
            echo '<div class="error"><p>Depunerea nu a fost găsită.</p></div>';
        }
    } else {
        echo '<div class="error"><p>Nu a fost furnizat niciun ID de depunere.</p></div>';
    }
}

function formularul230_remove_preview_submenu()
{
    remove_submenu_page('formularul230-admin', 'formularul230-submission-preview');
}
add_action('admin_menu', 'formularul230_remove_preview_submenu');

function formularul230_add_preview_page()
{
    add_submenu_page(
        null,
        'Submission Preview',
        'Submission Preview',
        'manage_options',
        'formularul230-submission-preview',
        'formularul230_submission_preview'
    );
}
add_action('admin_menu', 'formularul230_add_preview_page');

// Handle PDF preview via AJAX
function formularul230_preview_pdf_ajax()
{
    global $wpdb;

    check_ajax_referer('formularul230_preview_nonce', '_wpnonce');

    if (isset($_GET['id'])) {
        $id = intval($_GET['id']);
        $table_name = $wpdb->prefix . 'formularul230_submissions';
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $submission = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id), ARRAY_A);

        if ($submission) {
            $pdf_content = formularul230_preview_pdf($submission);

            if ($pdf_content) {
                header('Content-Type: application/pdf');
                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- PDF binary output
                echo $pdf_content;
                exit;
            } else {
                header('Content-Type: text/html');
                echo '<p>Eroare la generarea previzualizării PDF. Limita poate fi atinsă. Verificați notificările pentru detalii.</p>';
                exit;
            }
        } else {
            wp_die('Depunerea nu a fost găsită.');
        }
    }
}
add_action('wp_ajax_formularul230_preview_pdf', 'formularul230_preview_pdf_ajax');
add_action('wp_ajax_nopriv_formularul230_preview_pdf', 'formularul230_preview_pdf_ajax');

// Handle PDF download via AJAX
function formularul230_download_pdf_ajax()
{
    global $wpdb;

    check_ajax_referer('formularul230_download_nonce', '_wpnonce');

    if (isset($_GET['id'])) {
        $id = intval($_GET['id']);
        $table_name = $wpdb->prefix . 'formularul230_submissions';
        // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared
        $submission = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $id), ARRAY_A);

        if ($submission) {
            $pdf_content = formularul230_download_pdf($submission);

            if ($pdf_content) {
                $prename = ucfirst(strtolower($submission['prename']));
                $name = ucfirst(strtolower($submission['name']));
                $filename = 'Contribuabil-' . $submission['id'] . '-' . $prename . $name . '.pdf';

                header('Content-Type: application/pdf');
                header('Content-Disposition: attachment; filename="' . $filename . '"');
                header('Content-Length: ' . strlen($pdf_content));
                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- PDF binary output
                echo $pdf_content;
                exit;
            } else {
                header('Content-Type: text/html');
                echo '<p>Eroare la generarea PDF-ului pentru descărcare. Limita poate fi atinsă. Verificați notificările pentru detalii.</p>';
                exit;
            }
        } else {
            wp_die('Depunerea nu a fost găsită.');
        }
    }
}
add_action('wp_ajax_formularul230_download_pdf', 'formularul230_download_pdf_ajax');
add_action('wp_ajax_nopriv_formularul230_download_pdf', 'formularul230_download_pdf_ajax');